<?php

namespace Worldline\PaymentCore\Model\Country;

/**
 * phpcs:disable Magento2.Functions.StaticFunction
 * phpcs:disable Generic.Files.LineLength.TooLong
 * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
 */
class CountryData
{
    /**
     * Get all country data
     *
     * @return array
     */
    public static function getData()
    {
        return [
            'AF' => ['countryName' => 'Afghanistan', 'iso3' => 'AFG', 'isoNumeric' => '4', 'e164' => '93', 'phoneCode' => '93', 'capitalTimeZone' => 'Asia/Kabul', 'currency' => 'Afghani'],
            'AL' => ['countryName' => 'Albania', 'iso3' => 'ALB', 'isoNumeric' => '8', 'e164' => '355', 'phoneCode' => '355', 'capitalTimeZone' => 'Europe/Tirane', 'currency' => 'Lek'],
            'DZ' => ['countryName' => 'Algeria', 'iso3' => 'DZA', 'isoNumeric' => '12', 'e164' => '213', 'phoneCode' => '213', 'capitalTimeZone' => 'Africa/Algiers', 'currency' => 'Dinar'],
            'AS' => ['countryName' => 'American Samoa', 'iso3' => 'ASM', 'isoNumeric' => '16', 'e164' => '1', 'phoneCode' => '1-684', 'capitalTimeZone' => 'Pacific/Pago_Pago', 'currency' => 'Dollar'],
            'AD' => ['countryName' => 'Andorra', 'iso3' => 'AND', 'isoNumeric' => '20', 'e164' => '376', 'phoneCode' => '376', 'capitalTimeZone' => 'Europe/Andorra', 'currency' => 'Euro'],
            'AO' => ['countryName' => 'Angola', 'iso3' => 'AGO', 'isoNumeric' => '24', 'e164' => '244', 'phoneCode' => '244', 'capitalTimeZone' => 'Africa/Lagos', 'currency' => 'Kwanza'],
            'AI' => ['countryName' => 'Anguilla', 'iso3' => 'AIA', 'isoNumeric' => '660', 'e164' => '1', 'phoneCode' => '1-264', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Dollar'],
            'AQ' => ['countryName' => 'Antarctica', 'iso3' => 'ATA', 'isoNumeric' => '10', 'e164' => '672', 'phoneCode' => '672', 'capitalTimeZone' => 'Antarctica/Troll', 'currency' => ''],
            'AG' => ['countryName' => 'Antigua and Barbuda', 'iso3' => 'ATG', 'isoNumeric' => '28', 'e164' => '1', 'phoneCode' => '1-268', 'capitalTimeZone' => 'America/Antigua', 'currency' => 'Dollar'],
            'AR' => ['countryName' => 'Argentina', 'iso3' => 'ARG', 'isoNumeric' => '32', 'e164' => '54', 'phoneCode' => '54', 'capitalTimeZone' => 'America/Argentina/Buenos_Aires', 'currency' => 'Peso'],
            'AM' => ['countryName' => 'Armenia', 'iso3' => 'ARM', 'isoNumeric' => '51', 'e164' => '374', 'phoneCode' => '374', 'capitalTimeZone' => 'Asia/Yerevan', 'currency' => 'Dram'],
            'AW' => ['countryName' => 'Aruba', 'iso3' => 'ABW', 'isoNumeric' => '533', 'e164' => '297', 'phoneCode' => '297', 'capitalTimeZone' => 'America/Curacao', 'currency' => 'Guilder'],
            'AU' => ['countryName' => 'Australia', 'iso3' => 'AUS', 'isoNumeric' => '36', 'e164' => '61', 'phoneCode' => '61', 'capitalTimeZone' => 'Australia/Sydney', 'currency' => 'Dollar'],
            'AT' => ['countryName' => 'Austria', 'iso3' => 'AUT', 'isoNumeric' => '40', 'e164' => '43', 'phoneCode' => '43', 'capitalTimeZone' => 'Europe/Vienna', 'currency' => 'Euro'],
            'AZ' => ['countryName' => 'Azerbaijan', 'iso3' => 'AZE', 'isoNumeric' => '31', 'e164' => '994', 'phoneCode' => '994', 'capitalTimeZone' => 'Asia/Baku', 'currency' => 'Manat'],
            'BS' => ['countryName' => 'Bahamas', 'iso3' => 'BHS', 'isoNumeric' => '44', 'e164' => '1', 'phoneCode' => '1-242', 'capitalTimeZone' => 'America/Nassau', 'currency' => 'Dollar'],
            'BH' => ['countryName' => 'Bahrain', 'iso3' => 'BHR', 'isoNumeric' => '48', 'e164' => '973', 'phoneCode' => '973', 'capitalTimeZone' => 'Asia/Bahrain', 'currency' => 'Dinar'],
            'BD' => ['countryName' => 'Bangladesh', 'iso3' => 'BGD', 'isoNumeric' => '50', 'e164' => '880', 'phoneCode' => '880', 'capitalTimeZone' => 'Asia/Dhaka', 'currency' => 'Taka'],
            'BB' => ['countryName' => 'Barbados', 'iso3' => 'BRB', 'isoNumeric' => '52', 'e164' => '1', 'phoneCode' => '1-246', 'capitalTimeZone' => 'America/Barbados', 'currency' => 'Dollar'],
            'BY' => ['countryName' => 'Belarus', 'iso3' => 'BLR', 'isoNumeric' => '112', 'e164' => '375', 'phoneCode' => '375', 'capitalTimeZone' => 'Europe/Minsk', 'currency' => 'Ruble'],
            'BE' => ['countryName' => 'Belgium', 'iso3' => 'BEL', 'isoNumeric' => '56', 'e164' => '32', 'phoneCode' => '32', 'capitalTimeZone' => 'Europe/Brussels', 'currency' => 'Euro'],
            'BZ' => ['countryName' => 'Belize', 'iso3' => 'BLZ', 'isoNumeric' => '84', 'e164' => '501', 'phoneCode' => '501', 'capitalTimeZone' => 'America/Belize', 'currency' => 'Dollar'],
            'BJ' => ['countryName' => 'Benin', 'iso3' => 'BEN', 'isoNumeric' => '204', 'e164' => '229', 'phoneCode' => '229', 'capitalTimeZone' => 'Africa/Lagos', 'currency' => 'Franc'],
            'BM' => ['countryName' => 'Bermuda', 'iso3' => 'BMU', 'isoNumeric' => '60', 'e164' => '1', 'phoneCode' => '1-441', 'capitalTimeZone' => 'Atlantic/Bermuda', 'currency' => 'Dollar'],
            'BT' => ['countryName' => 'Bhutan', 'iso3' => 'BTN', 'isoNumeric' => '64', 'e164' => '975', 'phoneCode' => '975', 'capitalTimeZone' => 'Asia/Thimphu', 'currency' => 'Ngultrum'],
            'BO' => ['countryName' => 'Bolivia', 'iso3' => 'BOL', 'isoNumeric' => '68', 'e164' => '591', 'phoneCode' => '591', 'capitalTimeZone' => 'America/La_Paz', 'currency' => 'Boliviano'],
            'BA' => ['countryName' => 'Bosnia and Herzegovina', 'iso3' => 'BIH', 'isoNumeric' => '70', 'e164' => '387', 'phoneCode' => '387', 'capitalTimeZone' => 'Europe/Belgrade', 'currency' => 'Marka'],
            'BW' => ['countryName' => 'Botswana', 'iso3' => 'BWA', 'isoNumeric' => '72', 'e164' => '267', 'phoneCode' => '267', 'capitalTimeZone' => 'Africa/Maputo', 'currency' => 'Pula'],
            'BR' => ['countryName' => 'Brazil', 'iso3' => 'BRA', 'isoNumeric' => '76', 'e164' => '55', 'phoneCode' => '55', 'capitalTimeZone' => 'America/Sao_Paulo', 'currency' => 'Real'],
            'IO' => ['countryName' => 'British Indian Ocean Territory', 'iso3' => 'IOT', 'isoNumeric' => '86', 'e164' => '246', 'phoneCode' => '246', 'capitalTimeZone' => 'Indian/Chagos', 'currency' => 'Dollar'],
            'VG' => ['countryName' => 'British Virgin Islands', 'iso3' => 'VGB', 'isoNumeric' => '92', 'e164' => '1', 'phoneCode' => '1-284', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Dollar'],
            'BN' => ['countryName' => 'Brunei', 'iso3' => 'BRN', 'isoNumeric' => '96', 'e164' => '673', 'phoneCode' => '673', 'capitalTimeZone' => 'Asia/Brunei', 'currency' => 'Dollar'],
            'BG' => ['countryName' => 'Bulgaria', 'iso3' => 'BGR', 'isoNumeric' => '100', 'e164' => '359', 'phoneCode' => '359', 'capitalTimeZone' => 'Europe/Sofia', 'currency' => 'Lev'],
            'BF' => ['countryName' => 'Burkina Faso', 'iso3' => 'BFA', 'isoNumeric' => '854', 'e164' => '226', 'phoneCode' => '226', 'capitalTimeZone' => 'Africa/Abidjan', 'currency' => 'Franc'],
            'BI' => ['countryName' => 'Burundi', 'iso3' => 'BDI', 'isoNumeric' => '108', 'e164' => '257', 'phoneCode' => '257', 'capitalTimeZone' => 'Africa/Maputo', 'currency' => 'Franc'],
            'KH' => ['countryName' => 'Cambodia', 'iso3' => 'KHM', 'isoNumeric' => '116', 'e164' => '855', 'phoneCode' => '855', 'capitalTimeZone' => 'Asia/Phnom_Penh', 'currency' => 'Riels'],
            'CM' => ['countryName' => 'Cameroon', 'iso3' => 'CMR', 'isoNumeric' => '120', 'e164' => '237', 'phoneCode' => '237', 'capitalTimeZone' => 'Africa/Lagos', 'currency' => 'Franc'],
            'CA' => ['countryName' => 'Canada', 'iso3' => 'CAN', 'isoNumeric' => '124', 'e164' => '1', 'phoneCode' => '1', 'capitalTimeZone' => 'America/Toronto', 'currency' => 'Dollar'],
            'CV' => ['countryName' => 'Cape Verde', 'iso3' => 'CPV', 'isoNumeric' => '132', 'e164' => '238', 'phoneCode' => '238', 'capitalTimeZone' => 'Atlantic/Cape_Verde', 'currency' => 'Escudo'],
            'KY' => ['countryName' => 'Cayman Islands', 'iso3' => 'CYM', 'isoNumeric' => '136', 'e164' => '1', 'phoneCode' => '1-345', 'capitalTimeZone' => 'America/Cayman', 'currency' => 'Dollar'],
            'CF' => ['countryName' => 'Central African Republic', 'iso3' => 'CAF', 'isoNumeric' => '140', 'e164' => '236', 'phoneCode' => '236', 'capitalTimeZone' => 'Africa/Lagos', 'currency' => 'Franc'],
            'TD' => ['countryName' => 'Chad', 'iso3' => 'TCD', 'isoNumeric' => '148', 'e164' => '235', 'phoneCode' => '235', 'capitalTimeZone' => 'Africa/Ndjamena', 'currency' => 'Franc'],
            'CL' => ['countryName' => 'Chile', 'iso3' => 'CHL', 'isoNumeric' => '152', 'e164' => '56', 'phoneCode' => '56', 'capitalTimeZone' => 'America/Santiago', 'currency' => 'Peso'],
            'CN' => ['countryName' => 'China', 'iso3' => 'CHN', 'isoNumeric' => '156', 'e164' => '86', 'phoneCode' => '86', 'capitalTimeZone' => 'Asia/Shanghai', 'currency' => 'Yuan Renminbi'],
            'CX' => ['countryName' => 'Christmas Island', 'iso3' => 'CXR', 'isoNumeric' => '162', 'e164' => '61', 'phoneCode' => '61', 'capitalTimeZone' => 'Indian/Christmas', 'currency' => 'Dollar'],
            'CC' => ['countryName' => 'Cocos Islands', 'iso3' => 'CCK', 'isoNumeric' => '166', 'e164' => '61', 'phoneCode' => '61', 'capitalTimeZone' => 'Indian/Cocos', 'currency' => 'Dollar'],
            'CO' => ['countryName' => 'Colombia', 'iso3' => 'COL', 'isoNumeric' => '170', 'e164' => '57', 'phoneCode' => '57', 'capitalTimeZone' => 'America/Bogota', 'currency' => 'Peso'],
            'KM' => ['countryName' => 'Comoros', 'iso3' => 'COM', 'isoNumeric' => '174', 'e164' => '269', 'phoneCode' => '269', 'capitalTimeZone' => 'Indian/Comoro', 'currency' => 'Franc'],
            'CK' => ['countryName' => 'Cook Islands', 'iso3' => 'COK', 'isoNumeric' => '184', 'e164' => '682', 'phoneCode' => '682', 'capitalTimeZone' => 'Pacific/Rarotonga', 'currency' => 'Dollar'],
            'CR' => ['countryName' => 'Costa Rica', 'iso3' => 'CRI', 'isoNumeric' => '188', 'e164' => '506', 'phoneCode' => '506', 'capitalTimeZone' => 'America/Costa_Rica', 'currency' => 'Colon'],
            'HR' => ['countryName' => 'Croatia', 'iso3' => 'HRV', 'isoNumeric' => '191', 'e164' => '385', 'phoneCode' => '385', 'capitalTimeZone' => 'Europe/Belgrade', 'currency' => 'Kuna'],
            'CU' => ['countryName' => 'Cuba', 'iso3' => 'CUB', 'isoNumeric' => '192', 'e164' => '53', 'phoneCode' => '53', 'capitalTimeZone' => 'America/Havana', 'currency' => 'Peso'],
            'CW' => ['countryName' => 'Curacao', 'iso3' => 'CUW', 'isoNumeric' => '531', 'e164' => '599', 'phoneCode' => '599', 'capitalTimeZone' => 'America/Curacao', 'currency' => 'Guilder'],
            'CY' => ['countryName' => 'Cyprus', 'iso3' => 'CYP', 'isoNumeric' => '196', 'e164' => '357', 'phoneCode' => '357', 'capitalTimeZone' => 'Asia/Nicosia', 'currency' => 'Euro'],
            'CZ' => ['countryName' => 'Czech Republic', 'iso3' => 'CZE', 'isoNumeric' => '203', 'e164' => '420', 'phoneCode' => '420', 'capitalTimeZone' => 'Europe/Prague', 'currency' => 'Koruna'],
            'CD' => ['countryName' => 'Democratic Republic of the Congo', 'iso3' => 'COD', 'isoNumeric' => '180', 'e164' => '243', 'phoneCode' => '243', 'capitalTimeZone' => 'Africa/Lagos', 'currency' => 'Franc'],
            'DK' => ['countryName' => 'Denmark', 'iso3' => 'DNK', 'isoNumeric' => '208', 'e164' => '45', 'phoneCode' => '45', 'capitalTimeZone' => 'Europe/Copenhagen', 'currency' => 'Krone'],
            'DJ' => ['countryName' => 'Djibouti', 'iso3' => 'DJI', 'isoNumeric' => '262', 'e164' => '253', 'phoneCode' => '253', 'capitalTimeZone' => 'Africa/Djibouti', 'currency' => 'Franc'],
            'DM' => ['countryName' => 'Dominica', 'iso3' => 'DMA', 'isoNumeric' => '212', 'e164' => '1', 'phoneCode' => '1-767', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Dollar'],
            'DO' => ['countryName' => 'Dominican Republic', 'iso3' => 'DOM', 'isoNumeric' => '214', 'e164' => '1', 'phoneCode' => '1-809, 1-829, 1-849', 'capitalTimeZone' => 'America/Santo_Domingo', 'currency' => 'Peso'],
            'TL' => ['countryName' => 'East Timor', 'iso3' => 'TLS', 'isoNumeric' => '626', 'e164' => '670', 'phoneCode' => '670', 'capitalTimeZone' => 'Asia/Dili', 'currency' => 'Dollar'],
            'EC' => ['countryName' => 'Ecuador', 'iso3' => 'ECU', 'isoNumeric' => '218', 'e164' => '593', 'phoneCode' => '593', 'capitalTimeZone' => 'America/Guayaquil', 'currency' => 'Dollar'],
            'EG' => ['countryName' => 'Egypt', 'iso3' => 'EGY', 'isoNumeric' => '818', 'e164' => '20', 'phoneCode' => '20', 'capitalTimeZone' => 'Africa/Cairo', 'currency' => 'Pound'],
            'SV' => ['countryName' => 'El Salvador', 'iso3' => 'SLV', 'isoNumeric' => '222', 'e164' => '503', 'phoneCode' => '503', 'capitalTimeZone' => 'America/El_Salvador', 'currency' => 'Dollar'],
            'GQ' => ['countryName' => 'Equatorial Guinea', 'iso3' => 'GNQ', 'isoNumeric' => '226', 'e164' => '240', 'phoneCode' => '240', 'capitalTimeZone' => 'Africa/Lagos', 'currency' => 'Franc'],
            'ER' => ['countryName' => 'Eritrea', 'iso3' => 'ERI', 'isoNumeric' => '232', 'e164' => '291', 'phoneCode' => '291', 'capitalTimeZone' => 'Africa/Asmara', 'currency' => 'Nakfa'],
            'EE' => ['countryName' => 'Estonia', 'iso3' => 'EST', 'isoNumeric' => '233', 'e164' => '372', 'phoneCode' => '372', 'capitalTimeZone' => 'Europe/Tallinn', 'currency' => 'Euro'],
            'ET' => ['countryName' => 'Ethiopia', 'iso3' => 'ETH', 'isoNumeric' => '231', 'e164' => '251', 'phoneCode' => '251', 'capitalTimeZone' => 'Africa/Addis_Ababa', 'currency' => 'Birr'],
            'FK' => ['countryName' => 'Falkland Islands', 'iso3' => 'FLK', 'isoNumeric' => '238', 'e164' => '500', 'phoneCode' => '500', 'capitalTimeZone' => 'Atlantic/Stanley', 'currency' => 'Pound'],
            'FO' => ['countryName' => 'Faroe Islands', 'iso3' => 'FRO', 'isoNumeric' => '234', 'e164' => '298', 'phoneCode' => '298', 'capitalTimeZone' => 'Atlantic/Faroe', 'currency' => 'Krone'],
            'FJ' => ['countryName' => 'Fiji', 'iso3' => 'FJI', 'isoNumeric' => '242', 'e164' => '679', 'phoneCode' => '679', 'capitalTimeZone' => 'Pacific/Fiji', 'currency' => 'Dollar'],
            'FI' => ['countryName' => 'Finland', 'iso3' => 'FIN', 'isoNumeric' => '246', 'e164' => '358', 'phoneCode' => '358', 'capitalTimeZone' => 'Europe/Helsinki', 'currency' => 'Euro'],
            'FR' => ['countryName' => 'France', 'iso3' => 'FRA', 'isoNumeric' => '250', 'e164' => '33', 'phoneCode' => '33', 'capitalTimeZone' => 'Europe/Paris', 'currency' => 'Euro'],
            'PF' => ['countryName' => 'French Polynesia', 'iso3' => 'PYF', 'isoNumeric' => '258', 'e164' => '689', 'phoneCode' => '689', 'capitalTimeZone' => 'Pacific/Tahiti', 'currency' => 'Franc'],
            'GA' => ['countryName' => 'Gabon', 'iso3' => 'GAB', 'isoNumeric' => '266', 'e164' => '241', 'phoneCode' => '241', 'capitalTimeZone' => 'Africa/Lagos', 'currency' => 'Franc'],
            'GM' => ['countryName' => 'Gambia', 'iso3' => 'GMB', 'isoNumeric' => '270', 'e164' => '220', 'phoneCode' => '220', 'capitalTimeZone' => 'Africa/Abidjan', 'currency' => 'Dalasi'],
            'GE' => ['countryName' => 'Georgia', 'iso3' => 'GEO', 'isoNumeric' => '268', 'e164' => '995', 'phoneCode' => '995', 'capitalTimeZone' => 'Asia/Tbilisi', 'currency' => 'Lari'],
            'DE' => ['countryName' => 'Germany', 'iso3' => 'DEU', 'isoNumeric' => '276', 'e164' => '49', 'phoneCode' => '49', 'capitalTimeZone' => 'Europe/Berlin', 'currency' => 'Euro'],
            'GH' => ['countryName' => 'Ghana', 'iso3' => 'GHA', 'isoNumeric' => '288', 'e164' => '233', 'phoneCode' => '233', 'capitalTimeZone' => 'Africa/Accra', 'currency' => 'Cedi'],
            'GI' => ['countryName' => 'Gibraltar', 'iso3' => 'GIB', 'isoNumeric' => '292', 'e164' => '350', 'phoneCode' => '350', 'capitalTimeZone' => 'Europe/Gibraltar', 'currency' => 'Pound'],
            'GR' => ['countryName' => 'Greece', 'iso3' => 'GRC', 'isoNumeric' => '300', 'e164' => '30', 'phoneCode' => '30', 'capitalTimeZone' => 'Europe/Athens', 'currency' => 'Euro'],
            'GL' => ['countryName' => 'Greenland', 'iso3' => 'GRL', 'isoNumeric' => '304', 'e164' => '299', 'phoneCode' => '299', 'capitalTimeZone' => 'America/Godthab', 'currency' => 'Krone'],
            'GD' => ['countryName' => 'Grenada', 'iso3' => 'GRD', 'isoNumeric' => '308', 'e164' => '1', 'phoneCode' => '1-473', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Dollar'],
            'GU' => ['countryName' => 'Guam', 'iso3' => 'GUM', 'isoNumeric' => '316', 'e164' => '1', 'phoneCode' => '1-671', 'capitalTimeZone' => 'Pacific/Guam', 'currency' => 'Dollar'],
            'GT' => ['countryName' => 'Guatemala', 'iso3' => 'GTM', 'isoNumeric' => '320', 'e164' => '502', 'phoneCode' => '502', 'capitalTimeZone' => 'America/Guatemala', 'currency' => 'Quetzal'],
            'GG' => ['countryName' => 'Guernsey', 'iso3' => 'GGY', 'isoNumeric' => '831', 'e164' => '44', 'phoneCode' => '44-1481', 'capitalTimeZone' => 'Europe/London', 'currency' => 'Pound'],
            'GN' => ['countryName' => 'Guinea', 'iso3' => 'GIN', 'isoNumeric' => '324', 'e164' => '224', 'phoneCode' => '224', 'capitalTimeZone' => 'Africa/Abidjan', 'currency' => 'Franc'],
            'GW' => ['countryName' => 'Guinea-Bissau', 'iso3' => 'GNB', 'isoNumeric' => '624', 'e164' => '245', 'phoneCode' => '245', 'capitalTimeZone' => 'Africa/Bissau', 'currency' => 'Franc'],
            'GY' => ['countryName' => 'Guyana', 'iso3' => 'GUY', 'isoNumeric' => '328', 'e164' => '592', 'phoneCode' => '592', 'capitalTimeZone' => 'America/Guyana', 'currency' => 'Dollar'],
            'HT' => ['countryName' => 'Haiti', 'iso3' => 'HTI', 'isoNumeric' => '332', 'e164' => '509', 'phoneCode' => '509', 'capitalTimeZone' => 'America/Port-au-Prince', 'currency' => 'Gourde'],
            'HN' => ['countryName' => 'Honduras', 'iso3' => 'HND', 'isoNumeric' => '340', 'e164' => '504', 'phoneCode' => '504', 'capitalTimeZone' => 'America/Tegucigalpa', 'currency' => 'Lempira'],
            'HK' => ['countryName' => 'Hong Kong', 'iso3' => 'HKG', 'isoNumeric' => '344', 'e164' => '852', 'phoneCode' => '852', 'capitalTimeZone' => 'Asia/Hong_Kong', 'currency' => 'Dollar'],
            'HU' => ['countryName' => 'Hungary', 'iso3' => 'HUN', 'isoNumeric' => '348', 'e164' => '36', 'phoneCode' => '36', 'capitalTimeZone' => 'Europe/Budapest', 'currency' => 'Forint'],
            'IS' => ['countryName' => 'Iceland', 'iso3' => 'ISL', 'isoNumeric' => '352', 'e164' => '354', 'phoneCode' => '354', 'capitalTimeZone' => 'Atlantic/Reykjavik', 'currency' => 'Krona'],
            'IN' => ['countryName' => 'India', 'iso3' => 'IND', 'isoNumeric' => '356', 'e164' => '91', 'phoneCode' => '91', 'capitalTimeZone' => 'Asia/Kolkata', 'currency' => 'Rupee'],
            'ID' => ['countryName' => 'Indonesia', 'iso3' => 'IDN', 'isoNumeric' => '360', 'e164' => '62', 'phoneCode' => '62', 'capitalTimeZone' => 'Asia/Jakarta', 'currency' => 'Rupiah'],
            'IR' => ['countryName' => 'Iran', 'iso3' => 'IRN', 'isoNumeric' => '364', 'e164' => '98', 'phoneCode' => '98', 'capitalTimeZone' => 'Asia/Tehran', 'currency' => 'Rial'],
            'IQ' => ['countryName' => 'Iraq', 'iso3' => 'IRQ', 'isoNumeric' => '368', 'e164' => '964', 'phoneCode' => '964', 'capitalTimeZone' => 'Asia/Baghdad', 'currency' => 'Dinar'],
            'IE' => ['countryName' => 'Ireland', 'iso3' => 'IRL', 'isoNumeric' => '372', 'e164' => '353', 'phoneCode' => '353', 'capitalTimeZone' => 'Europe/Dublin', 'currency' => 'Euro'],
            'IM' => ['countryName' => 'Isle of Man', 'iso3' => 'IMN', 'isoNumeric' => '833', 'e164' => '44', 'phoneCode' => '44-1624', 'capitalTimeZone' => 'Europe/London', 'currency' => 'Pound'],
            'IL' => ['countryName' => 'Israel', 'iso3' => 'ISR', 'isoNumeric' => '376', 'e164' => '972', 'phoneCode' => '972', 'capitalTimeZone' => 'Asia/Jerusalem', 'currency' => 'Shekel'],
            'IT' => ['countryName' => 'Italy', 'iso3' => 'ITA', 'isoNumeric' => '380', 'e164' => '39', 'phoneCode' => '39', 'capitalTimeZone' => 'Europe/Rome', 'currency' => 'Euro'],
            'CI' => ['countryName' => 'Ivory Coast', 'iso3' => 'CIV', 'isoNumeric' => '384', 'e164' => '225', 'phoneCode' => '225', 'capitalTimeZone' => 'Africa/Abidjan', 'currency' => 'Franc'],
            'JM' => ['countryName' => 'Jamaica', 'iso3' => 'JAM', 'isoNumeric' => '388', 'e164' => '1', 'phoneCode' => '1-876', 'capitalTimeZone' => 'America/Jamaica', 'currency' => 'Dollar'],
            'JP' => ['countryName' => 'Japan', 'iso3' => 'JPN', 'isoNumeric' => '392', 'e164' => '81', 'phoneCode' => '81', 'capitalTimeZone' => 'Asia/Tokyo', 'currency' => 'Yen'],
            'JE' => ['countryName' => 'Jersey', 'iso3' => 'JEY', 'isoNumeric' => '832', 'e164' => '44', 'phoneCode' => '44-1534', 'capitalTimeZone' => 'Europe/London', 'currency' => 'Pound'],
            'JO' => ['countryName' => 'Jordan', 'iso3' => 'JOR', 'isoNumeric' => '400', 'e164' => '962', 'phoneCode' => '962', 'capitalTimeZone' => 'Asia/Amman', 'currency' => 'Dinar'],
            'KZ' => ['countryName' => 'Kazakhstan', 'iso3' => 'KAZ', 'isoNumeric' => '398', 'e164' => '7', 'phoneCode' => '7', 'capitalTimeZone' => 'Asia/Almaty', 'currency' => 'Tenge'],
            'KE' => ['countryName' => 'Kenya', 'iso3' => 'KEN', 'isoNumeric' => '404', 'e164' => '254', 'phoneCode' => '254', 'capitalTimeZone' => 'Africa/Nairobi', 'currency' => 'Shilling'],
            'KI' => ['countryName' => 'Kiribati', 'iso3' => 'KIR', 'isoNumeric' => '296', 'e164' => '686', 'phoneCode' => '686', 'capitalTimeZone' => 'Pacific/Tarawa', 'currency' => 'Dollar'],
            'XK' => ['countryName' => 'Kosovo', 'iso3' => 'XKX', 'isoNumeric' => '0', 'e164' => '383', 'phoneCode' => '383', 'capitalTimeZone' => 'Europe/Belgrade', 'currency' => 'Euro'],
            'KW' => ['countryName' => 'Kuwait', 'iso3' => 'KWT', 'isoNumeric' => '414', 'e164' => '965', 'phoneCode' => '965', 'capitalTimeZone' => 'Asia/Kuwait', 'currency' => 'Dinar'],
            'KG' => ['countryName' => 'Kyrgyzstan', 'iso3' => 'KGZ', 'isoNumeric' => '417', 'e164' => '996', 'phoneCode' => '996', 'capitalTimeZone' => 'Asia/Bishkek', 'currency' => 'Som'],
            'LA' => ['countryName' => 'Laos', 'iso3' => 'LAO', 'isoNumeric' => '418', 'e164' => '856', 'phoneCode' => '856', 'capitalTimeZone' => 'Asia/Vientiane', 'currency' => 'Kip'],
            'LV' => ['countryName' => 'Latvia', 'iso3' => 'LVA', 'isoNumeric' => '428', 'e164' => '371', 'phoneCode' => '371', 'capitalTimeZone' => 'Europe/Riga', 'currency' => 'Euro'],
            'LB' => ['countryName' => 'Lebanon', 'iso3' => 'LBN', 'isoNumeric' => '422', 'e164' => '961', 'phoneCode' => '961', 'capitalTimeZone' => 'Asia/Beirut', 'currency' => 'Pound'],
            'LS' => ['countryName' => 'Lesotho', 'iso3' => 'LSO', 'isoNumeric' => '426', 'e164' => '266', 'phoneCode' => '266', 'capitalTimeZone' => 'Africa/Johannesburg', 'currency' => 'Loti'],
            'LR' => ['countryName' => 'Liberia', 'iso3' => 'LBR', 'isoNumeric' => '430', 'e164' => '231', 'phoneCode' => '231', 'capitalTimeZone' => 'Africa/Monrovia', 'currency' => 'Dollar'],
            'LY' => ['countryName' => 'Libya', 'iso3' => 'LBY', 'isoNumeric' => '434', 'e164' => '218', 'phoneCode' => '218', 'capitalTimeZone' => 'Africa/Tripoli', 'currency' => 'Dinar'],
            'LI' => ['countryName' => 'Liechtenstein', 'iso3' => 'LIE', 'isoNumeric' => '438', 'e164' => '423', 'phoneCode' => '423', 'capitalTimeZone' => 'Europe/Zurich', 'currency' => 'Franc'],
            'LT' => ['countryName' => 'Lithuania', 'iso3' => 'LTU', 'isoNumeric' => '440', 'e164' => '370', 'phoneCode' => '370', 'capitalTimeZone' => 'Europe/Vilnius', 'currency' => 'Euro'],
            'LU' => ['countryName' => 'Luxembourg', 'iso3' => 'LUX', 'isoNumeric' => '442', 'e164' => '352', 'phoneCode' => '352', 'capitalTimeZone' => 'Europe/Luxembourg', 'currency' => 'Euro'],
            'MO' => ['countryName' => 'Macau', 'iso3' => 'MAC', 'isoNumeric' => '446', 'e164' => '853', 'phoneCode' => '853', 'capitalTimeZone' => 'Asia/Macau', 'currency' => 'Pataca'],
            'MK' => ['countryName' => 'Macedonia', 'iso3' => 'MKD', 'isoNumeric' => '807', 'e164' => '389', 'phoneCode' => '389', 'capitalTimeZone' => 'Europe/Belgrade', 'currency' => 'Denar'],
            'MG' => ['countryName' => 'Madagascar', 'iso3' => 'MDG', 'isoNumeric' => '450', 'e164' => '261', 'phoneCode' => '261', 'capitalTimeZone' => 'Indian/Antananarivo', 'currency' => 'Ariary'],
            'MW' => ['countryName' => 'Malawi', 'iso3' => 'MWI', 'isoNumeric' => '454', 'e164' => '265', 'phoneCode' => '265', 'capitalTimeZone' => 'Africa/Maputo', 'currency' => 'Kwacha'],
            'MY' => ['countryName' => 'Malaysia', 'iso3' => 'MYS', 'isoNumeric' => '458', 'e164' => '60', 'phoneCode' => '60', 'capitalTimeZone' => 'Asia/Kuala_Lumpur', 'currency' => 'Ringgit'],
            'MV' => ['countryName' => 'Maldives', 'iso3' => 'MDV', 'isoNumeric' => '462', 'e164' => '960', 'phoneCode' => '960', 'capitalTimeZone' => 'Indian/Maldives', 'currency' => 'Rufiyaa'],
            'ML' => ['countryName' => 'Mali', 'iso3' => 'MLI', 'isoNumeric' => '466', 'e164' => '223', 'phoneCode' => '223', 'capitalTimeZone' => 'Africa/Abidjan', 'currency' => 'Franc'],
            'MT' => ['countryName' => 'Malta', 'iso3' => 'MLT', 'isoNumeric' => '470', 'e164' => '356', 'phoneCode' => '356', 'capitalTimeZone' => 'Europe/Malta', 'currency' => 'Euro'],
            'MH' => ['countryName' => 'Marshall Islands', 'iso3' => 'MHL', 'isoNumeric' => '584', 'e164' => '692', 'phoneCode' => '692', 'capitalTimeZone' => 'Pacific/Majuro', 'currency' => 'Dollar'],
            'MR' => ['countryName' => 'Mauritania', 'iso3' => 'MRT', 'isoNumeric' => '478', 'e164' => '222', 'phoneCode' => '222', 'capitalTimeZone' => 'Africa/Abidjan', 'currency' => 'Ouguiya'],
            'MU' => ['countryName' => 'Mauritius', 'iso3' => 'MUS', 'isoNumeric' => '480', 'e164' => '230', 'phoneCode' => '230', 'capitalTimeZone' => 'Indian/Mauritius', 'currency' => 'Rupee'],
            'YT' => ['countryName' => 'Mayotte', 'iso3' => 'MYT', 'isoNumeric' => '175', 'e164' => '262', 'phoneCode' => '262', 'capitalTimeZone' => 'Indian/Mayotte', 'currency' => 'Euro'],
            'MX' => ['countryName' => 'Mexico', 'iso3' => 'MEX', 'isoNumeric' => '484', 'e164' => '52', 'phoneCode' => '52', 'capitalTimeZone' => 'America/Mexico_City', 'currency' => 'Peso'],
            'FM' => ['countryName' => 'Micronesia', 'iso3' => 'FSM', 'isoNumeric' => '583', 'e164' => '691', 'phoneCode' => '691', 'capitalTimeZone' => 'Pacific/Pohnpei', 'currency' => 'Dollar'],
            'MD' => ['countryName' => 'Moldova', 'iso3' => 'MDA', 'isoNumeric' => '498', 'e164' => '373', 'phoneCode' => '373', 'capitalTimeZone' => 'Europe/Chisinau', 'currency' => 'Leu'],
            'MC' => ['countryName' => 'Monaco', 'iso3' => 'MCO', 'isoNumeric' => '492', 'e164' => '377', 'phoneCode' => '377', 'capitalTimeZone' => 'Europe/Monaco', 'currency' => 'Euro'],
            'MN' => ['countryName' => 'Mongolia', 'iso3' => 'MNG', 'isoNumeric' => '496', 'e164' => '976', 'phoneCode' => '976', 'capitalTimeZone' => 'Asia/Ulaanbaatar', 'currency' => 'Tugrik'],
            'ME' => ['countryName' => 'Montenegro', 'iso3' => 'MNE', 'isoNumeric' => '499', 'e164' => '382', 'phoneCode' => '382', 'capitalTimeZone' => 'Europe/Belgrade', 'currency' => 'Euro'],
            'MS' => ['countryName' => 'Montserrat', 'iso3' => 'MSR', 'isoNumeric' => '500', 'e164' => '1', 'phoneCode' => '1-664', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Dollar'],
            'MA' => ['countryName' => 'Morocco', 'iso3' => 'MAR', 'isoNumeric' => '504', 'e164' => '212', 'phoneCode' => '212', 'capitalTimeZone' => 'Africa/Casablanca', 'currency' => 'Dirham'],
            'MZ' => ['countryName' => 'Mozambique', 'iso3' => 'MOZ', 'isoNumeric' => '508', 'e164' => '258', 'phoneCode' => '258', 'capitalTimeZone' => 'Africa/Maputo', 'currency' => 'Metical'],
            'MM' => ['countryName' => 'Myanmar', 'iso3' => 'MMR', 'isoNumeric' => '104', 'e164' => '95', 'phoneCode' => '95', 'capitalTimeZone' => 'Asia/Rangoon', 'currency' => 'Kyat'],
            'NA' => ['countryName' => 'Namibia', 'iso3' => 'NAM', 'isoNumeric' => '516', 'e164' => '264', 'phoneCode' => '264', 'capitalTimeZone' => 'Africa/Windhoek', 'currency' => 'Dollar'],
            'NR' => ['countryName' => 'Nauru', 'iso3' => 'NRU', 'isoNumeric' => '520', 'e164' => '674', 'phoneCode' => '674', 'capitalTimeZone' => 'Pacific/Nauru', 'currency' => 'Dollar'],
            'NP' => ['countryName' => 'Nepal', 'iso3' => 'NPL', 'isoNumeric' => '524', 'e164' => '977', 'phoneCode' => '977', 'capitalTimeZone' => 'Asia/Kathmandu', 'currency' => 'Rupee'],
            'NL' => ['countryName' => 'Netherlands', 'iso3' => 'NLD', 'isoNumeric' => '528', 'e164' => '31', 'phoneCode' => '31', 'capitalTimeZone' => 'Europe/Amsterdam', 'currency' => 'Euro'],
            'AN' => ['countryName' => 'Netherlands Antilles', 'iso3' => 'ANT', 'isoNumeric' => '530', 'e164' => '599', 'phoneCode' => '599', 'capitalTimeZone' => 'America/Curacao', 'currency' => 'Guilder'],
            'NC' => ['countryName' => 'New Caledonia', 'iso3' => 'NCL', 'isoNumeric' => '540', 'e164' => '687', 'phoneCode' => '687', 'capitalTimeZone' => 'Pacific/Noumea', 'currency' => 'Franc'],
            'NZ' => ['countryName' => 'New Zealand', 'iso3' => 'NZL', 'isoNumeric' => '554', 'e164' => '64', 'phoneCode' => '64', 'capitalTimeZone' => 'Pacific/Auckland', 'currency' => 'Dollar'],
            'NI' => ['countryName' => 'Nicaragua', 'iso3' => 'NIC', 'isoNumeric' => '558', 'e164' => '505', 'phoneCode' => '505', 'capitalTimeZone' => 'America/Managua', 'currency' => 'Cordoba'],
            'NE' => ['countryName' => 'Niger', 'iso3' => 'NER', 'isoNumeric' => '562', 'e164' => '227', 'phoneCode' => '227', 'capitalTimeZone' => 'Africa/Lagos', 'currency' => 'Franc'],
            'NG' => ['countryName' => 'Nigeria', 'iso3' => 'NGA', 'isoNumeric' => '566', 'e164' => '234', 'phoneCode' => '234', 'capitalTimeZone' => 'Africa/Lagos', 'currency' => 'Naira'],
            'NU' => ['countryName' => 'Niue', 'iso3' => 'NIU', 'isoNumeric' => '570', 'e164' => '683', 'phoneCode' => '683', 'capitalTimeZone' => 'Pacific/Niue', 'currency' => 'Dollar'],
            'KP' => ['countryName' => 'North Korea', 'iso3' => 'PRK', 'isoNumeric' => '408', 'e164' => '850', 'phoneCode' => '850', 'capitalTimeZone' => 'Asia/Pyongyang', 'currency' => 'Won'],
            'MP' => ['countryName' => 'Northern Mariana Islands', 'iso3' => 'MNP', 'isoNumeric' => '580', 'e164' => '1', 'phoneCode' => '1-670', 'capitalTimeZone' => 'Pacific/Saipan', 'currency' => 'Dollar'],
            'NO' => ['countryName' => 'Norway', 'iso3' => 'NOR', 'isoNumeric' => '578', 'e164' => '47', 'phoneCode' => '47', 'capitalTimeZone' => 'Europe/Oslo', 'currency' => 'Krone'],
            'OM' => ['countryName' => 'Oman', 'iso3' => 'OMN', 'isoNumeric' => '512', 'e164' => '968', 'phoneCode' => '968', 'capitalTimeZone' => 'Asia/Muscat', 'currency' => 'Rial'],
            'PK' => ['countryName' => 'Pakistan', 'iso3' => 'PAK', 'isoNumeric' => '586', 'e164' => '92', 'phoneCode' => '92', 'capitalTimeZone' => 'Asia/Karachi', 'currency' => 'Rupee'],
            'PW' => ['countryName' => 'Palau', 'iso3' => 'PLW', 'isoNumeric' => '585', 'e164' => '680', 'phoneCode' => '680', 'capitalTimeZone' => 'Pacific/Palau', 'currency' => 'Dollar'],
            'PS' => ['countryName' => 'Palestine', 'iso3' => 'PSE', 'isoNumeric' => '275', 'e164' => '970', 'phoneCode' => '970', 'capitalTimeZone' => 'Asia/Hebron', 'currency' => 'Shekel'],
            'PA' => ['countryName' => 'Panama', 'iso3' => 'PAN', 'isoNumeric' => '591', 'e164' => '507', 'phoneCode' => '507', 'capitalTimeZone' => 'America/Panama', 'currency' => 'Balboa'],
            'PG' => ['countryName' => 'Papua New Guinea', 'iso3' => 'PNG', 'isoNumeric' => '598', 'e164' => '675', 'phoneCode' => '675', 'capitalTimeZone' => 'Pacific/Port_Moresby', 'currency' => 'Kina'],
            'PY' => ['countryName' => 'Paraguay', 'iso3' => 'PRY', 'isoNumeric' => '600', 'e164' => '595', 'phoneCode' => '595', 'capitalTimeZone' => 'America/Asuncion', 'currency' => 'Guarani'],
            'PE' => ['countryName' => 'Peru', 'iso3' => 'PER', 'isoNumeric' => '604', 'e164' => '51', 'phoneCode' => '51', 'capitalTimeZone' => 'America/Lima', 'currency' => 'Sol'],
            'PH' => ['countryName' => 'Philippines', 'iso3' => 'PHL', 'isoNumeric' => '608', 'e164' => '63', 'phoneCode' => '63', 'capitalTimeZone' => 'Asia/Manila', 'currency' => 'Peso'],
            'PN' => ['countryName' => 'Pitcairn', 'iso3' => 'PCN', 'isoNumeric' => '612', 'e164' => '64', 'phoneCode' => '64', 'capitalTimeZone' => 'Pacific/Pitcairn', 'currency' => 'Dollar'],
            'PL' => ['countryName' => 'Poland', 'iso3' => 'POL', 'isoNumeric' => '616', 'e164' => '48', 'phoneCode' => '48', 'capitalTimeZone' => 'Europe/Warsaw', 'currency' => 'Zloty'],
            'PT' => ['countryName' => 'Portugal', 'iso3' => 'PRT', 'isoNumeric' => '620', 'e164' => '351', 'phoneCode' => '351', 'capitalTimeZone' => 'Europe/Lisbon', 'currency' => 'Euro'],
            'PR' => ['countryName' => 'Puerto Rico', 'iso3' => 'PRI', 'isoNumeric' => '630', 'e164' => '1', 'phoneCode' => '1-787, 1-939', 'capitalTimeZone' => 'America/Puerto_Rico', 'currency' => 'Dollar'],
            'QA' => ['countryName' => 'Qatar', 'iso3' => 'QAT', 'isoNumeric' => '634', 'e164' => '974', 'phoneCode' => '974', 'capitalTimeZone' => 'Asia/Qatar', 'currency' => 'Rial'],
            'CG' => ['countryName' => 'Republic of the Congo', 'iso3' => 'COG', 'isoNumeric' => '178', 'e164' => '242', 'phoneCode' => '242', 'capitalTimeZone' => 'Africa/Lagos', 'currency' => 'Franc'],
            'RE' => ['countryName' => 'Reunion', 'iso3' => 'REU', 'isoNumeric' => '638', 'e164' => '262', 'phoneCode' => '262', 'capitalTimeZone' => 'Indian/Reunion', 'currency' => 'Euro'],
            'RO' => ['countryName' => 'Romania', 'iso3' => 'ROU', 'isoNumeric' => '642', 'e164' => '40', 'phoneCode' => '40', 'capitalTimeZone' => 'Europe/Bucharest', 'currency' => 'Leu'],
            'RU' => ['countryName' => 'Russia', 'iso3' => 'RUS', 'isoNumeric' => '643', 'e164' => '7', 'phoneCode' => '7', 'capitalTimeZone' => 'Europe/Moscow', 'currency' => 'Ruble'],
            'RW' => ['countryName' => 'Rwanda', 'iso3' => 'RWA', 'isoNumeric' => '646', 'e164' => '250', 'phoneCode' => '250', 'capitalTimeZone' => 'Africa/Maputo', 'currency' => 'Franc'],
            'BL' => ['countryName' => 'Saint Barthelemy', 'iso3' => 'BLM', 'isoNumeric' => '652', 'e164' => '590', 'phoneCode' => '590', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Euro'],
            'SH' => ['countryName' => 'Saint Helena', 'iso3' => 'SHN', 'isoNumeric' => '654', 'e164' => '290', 'phoneCode' => '290', 'capitalTimeZone' => 'Africa/Abidjan', 'currency' => 'Pound'],
            'KN' => ['countryName' => 'Saint Kitts and Nevis', 'iso3' => 'KNA', 'isoNumeric' => '659', 'e164' => '1', 'phoneCode' => '1-869', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Dollar'],
            'LC' => ['countryName' => 'Saint Lucia', 'iso3' => 'LCA', 'isoNumeric' => '662', 'e164' => '1', 'phoneCode' => '1-758', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Dollar'],
            'MF' => ['countryName' => 'Saint Martin', 'iso3' => 'MAF', 'isoNumeric' => '663', 'e164' => '1', 'phoneCode' => '590', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Euro'],
            'PM' => ['countryName' => 'Saint Pierre and Miquelon', 'iso3' => 'SPM', 'isoNumeric' => '666', 'e164' => '508', 'phoneCode' => '508', 'capitalTimeZone' => 'America/Miquelon', 'currency' => 'Euro'],
            'VC' => ['countryName' => 'Saint Vincent and the Grenadines', 'iso3' => 'VCT', 'isoNumeric' => '670', 'e164' => '1', 'phoneCode' => '1-784', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Dollar'],
            'WS' => ['countryName' => 'Samoa', 'iso3' => 'WSM', 'isoNumeric' => '882', 'e164' => '685', 'phoneCode' => '685', 'capitalTimeZone' => 'Pacific/Apia', 'currency' => 'Tala'],
            'SM' => ['countryName' => 'San Marino', 'iso3' => 'SMR', 'isoNumeric' => '674', 'e164' => '378', 'phoneCode' => '378', 'capitalTimeZone' => 'Europe/Rome', 'currency' => 'Euro'],
            'ST' => ['countryName' => 'Sao Tome and Principe', 'iso3' => 'STP', 'isoNumeric' => '678', 'e164' => '239', 'phoneCode' => '239', 'capitalTimeZone' => 'Africa/Abidjan', 'currency' => 'Dobra'],
            'SA' => ['countryName' => 'Saudi Arabia', 'iso3' => 'SAU', 'isoNumeric' => '682', 'e164' => '966', 'phoneCode' => '966', 'capitalTimeZone' => 'Asia/Riyadh', 'currency' => 'Rial'],
            'SN' => ['countryName' => 'Senegal', 'iso3' => 'SEN', 'isoNumeric' => '686', 'e164' => '221', 'phoneCode' => '221', 'capitalTimeZone' => 'Africa/Abidjan', 'currency' => 'Franc'],
            'RS' => ['countryName' => 'Serbia', 'iso3' => 'SRB', 'isoNumeric' => '688', 'e164' => '381', 'phoneCode' => '381', 'capitalTimeZone' => 'Europe/Belgrade', 'currency' => 'Dinar'],
            'SC' => ['countryName' => 'Seychelles', 'iso3' => 'SYC', 'isoNumeric' => '690', 'e164' => '248', 'phoneCode' => '248', 'capitalTimeZone' => 'Indian/Mahe', 'currency' => 'Rupee'],
            'SL' => ['countryName' => 'Sierra Leone', 'iso3' => 'SLE', 'isoNumeric' => '694', 'e164' => '232', 'phoneCode' => '232', 'capitalTimeZone' => 'Africa/Abidjan', 'currency' => 'Leone'],
            'SG' => ['countryName' => 'Singapore', 'iso3' => 'SGP', 'isoNumeric' => '702', 'e164' => '65', 'phoneCode' => '65', 'capitalTimeZone' => 'Asia/Singapore', 'currency' => 'Dollar'],
            'SX' => ['countryName' => 'Sint Maarten', 'iso3' => 'SXM', 'isoNumeric' => '534', 'e164' => '1', 'phoneCode' => '1-721', 'capitalTimeZone' => 'America/Curacao', 'currency' => 'Guilder'],
            'SK' => ['countryName' => 'Slovakia', 'iso3' => 'SVK', 'isoNumeric' => '703', 'e164' => '421', 'phoneCode' => '421', 'capitalTimeZone' => 'Europe/Prague', 'currency' => 'Euro'],
            'SI' => ['countryName' => 'Slovenia', 'iso3' => 'SVN', 'isoNumeric' => '705', 'e164' => '386', 'phoneCode' => '386', 'capitalTimeZone' => 'Europe/Belgrade', 'currency' => 'Euro'],
            'SB' => ['countryName' => 'Solomon Islands', 'iso3' => 'SLB', 'isoNumeric' => '90', 'e164' => '677', 'phoneCode' => '677', 'capitalTimeZone' => 'Pacific/Guadalcanal', 'currency' => 'Dollar'],
            'SO' => ['countryName' => 'Somalia', 'iso3' => 'SOM', 'isoNumeric' => '706', 'e164' => '252', 'phoneCode' => '252', 'capitalTimeZone' => 'Africa/Mogadishu', 'currency' => 'Shilling'],
            'ZA' => ['countryName' => 'South Africa', 'iso3' => 'ZAF', 'isoNumeric' => '710', 'e164' => '27', 'phoneCode' => '27', 'capitalTimeZone' => 'Africa/Johannesburg', 'currency' => 'Rand'],
            'KR' => ['countryName' => 'South Korea', 'iso3' => 'KOR', 'isoNumeric' => '410', 'e164' => '82', 'phoneCode' => '82', 'capitalTimeZone' => 'Asia/Seoul', 'currency' => 'Won'],
            'SS' => ['countryName' => 'South Sudan', 'iso3' => 'SSD', 'isoNumeric' => '728', 'e164' => '211', 'phoneCode' => '211', 'capitalTimeZone' => 'Africa/Khartoum', 'currency' => 'Pound'],
            'ES' => ['countryName' => 'Spain', 'iso3' => 'ESP', 'isoNumeric' => '724', 'e164' => '34', 'phoneCode' => '34', 'capitalTimeZone' => 'Europe/Madrid', 'currency' => 'Euro'],
            'LK' => ['countryName' => 'Sri Lanka', 'iso3' => 'LKA', 'isoNumeric' => '144', 'e164' => '94', 'phoneCode' => '94', 'capitalTimeZone' => 'Asia/Colombo', 'currency' => 'Rupee'],
            'SD' => ['countryName' => 'Sudan', 'iso3' => 'SDN', 'isoNumeric' => '729', 'e164' => '249', 'phoneCode' => '249', 'capitalTimeZone' => 'Africa/Khartoum', 'currency' => 'Pound'],
            'SR' => ['countryName' => 'Suriname', 'iso3' => 'SUR', 'isoNumeric' => '740', 'e164' => '597', 'phoneCode' => '597', 'capitalTimeZone' => 'America/Paramaribo', 'currency' => 'Dollar'],
            'SJ' => ['countryName' => 'Svalbard and Jan Mayen', 'iso3' => 'SJM', 'isoNumeric' => '744', 'e164' => '47', 'phoneCode' => '47', 'capitalTimeZone' => 'Europe/Oslo', 'currency' => 'Krone'],
            'SZ' => ['countryName' => 'Swaziland', 'iso3' => 'SWZ', 'isoNumeric' => '748', 'e164' => '268', 'phoneCode' => '268', 'capitalTimeZone' => 'Africa/Johannesburg', 'currency' => 'Lilangeni'],
            'SE' => ['countryName' => 'Sweden', 'iso3' => 'SWE', 'isoNumeric' => '752', 'e164' => '46', 'phoneCode' => '46', 'capitalTimeZone' => 'Europe/Stockholm', 'currency' => 'Krona'],
            'CH' => ['countryName' => 'Switzerland', 'iso3' => 'CHE', 'isoNumeric' => '756', 'e164' => '41', 'phoneCode' => '41', 'capitalTimeZone' => 'Europe/Zurich', 'currency' => 'Franc'],
            'SY' => ['countryName' => 'Syria', 'iso3' => 'SYR', 'isoNumeric' => '760', 'e164' => '963', 'phoneCode' => '963', 'capitalTimeZone' => 'Asia/Damascus', 'currency' => 'Pound'],
            'TW' => ['countryName' => 'Taiwan', 'iso3' => 'TWN', 'isoNumeric' => '158', 'e164' => '886', 'phoneCode' => '886', 'capitalTimeZone' => 'Asia/Taipei', 'currency' => 'Dollar'],
            'TJ' => ['countryName' => 'Tajikistan', 'iso3' => 'TJK', 'isoNumeric' => '762', 'e164' => '992', 'phoneCode' => '992', 'capitalTimeZone' => 'Asia/Dushanbe', 'currency' => 'Somoni'],
            'TZ' => ['countryName' => 'Tanzania', 'iso3' => 'TZA', 'isoNumeric' => '834', 'e164' => '255', 'phoneCode' => '255', 'capitalTimeZone' => 'Africa/Dar_es_Salaam', 'currency' => 'Shilling'],
            'TH' => ['countryName' => 'Thailand', 'iso3' => 'THA', 'isoNumeric' => '764', 'e164' => '66', 'phoneCode' => '66', 'capitalTimeZone' => 'Asia/Bangkok', 'currency' => 'Baht'],
            'TG' => ['countryName' => 'Togo', 'iso3' => 'TGO', 'isoNumeric' => '768', 'e164' => '228', 'phoneCode' => '228', 'capitalTimeZone' => 'Africa/Abidjan', 'currency' => 'Franc'],
            'TK' => ['countryName' => 'Tokelau', 'iso3' => 'TKL', 'isoNumeric' => '772', 'e164' => '690', 'phoneCode' => '690', 'capitalTimeZone' => 'Pacific/Fakaofo', 'currency' => 'Dollar'],
            'TO' => ['countryName' => 'Tonga', 'iso3' => 'TON', 'isoNumeric' => '776', 'e164' => '676', 'phoneCode' => '676', 'capitalTimeZone' => 'Pacific/Tongatapu', 'currency' => 'Pa\'anga'],
            'TT' => ['countryName' => 'Trinidad and Tobago', 'iso3' => 'TTO', 'isoNumeric' => '780', 'e164' => '1', 'phoneCode' => '1-868', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Dollar'],
            'TN' => ['countryName' => 'Tunisia', 'iso3' => 'TUN', 'isoNumeric' => '788', 'e164' => '216', 'phoneCode' => '216', 'capitalTimeZone' => 'Africa/Tunis', 'currency' => 'Dinar'],
            'TR' => ['countryName' => 'Turkey', 'iso3' => 'TUR', 'isoNumeric' => '792', 'e164' => '90', 'phoneCode' => '90', 'capitalTimeZone' => 'Europe/Istanbul', 'currency' => 'Lira'],
            'TM' => ['countryName' => 'Turkmenistan', 'iso3' => 'TKM', 'isoNumeric' => '795', 'e164' => '993', 'phoneCode' => '993', 'capitalTimeZone' => 'Asia/Ashgabat', 'currency' => 'Manat'],
            'TC' => ['countryName' => 'Turks and Caicos Islands', 'iso3' => 'TCA', 'isoNumeric' => '796', 'e164' => '1', 'phoneCode' => '1-649', 'capitalTimeZone' => 'America/Grand_Turk', 'currency' => 'Dollar'],
            'TV' => ['countryName' => 'Tuvalu', 'iso3' => 'TUV', 'isoNumeric' => '798', 'e164' => '688', 'phoneCode' => '688', 'capitalTimeZone' => 'Pacific/Funafuti', 'currency' => 'Dollar'],
            'VI' => ['countryName' => 'U.S. Virgin Islands', 'iso3' => 'VIR', 'isoNumeric' => '850', 'e164' => '1', 'phoneCode' => '1-340', 'capitalTimeZone' => 'America/Port_of_Spain', 'currency' => 'Dollar'],
            'UG' => ['countryName' => 'Uganda', 'iso3' => 'UGA', 'isoNumeric' => '800', 'e164' => '256', 'phoneCode' => '256', 'capitalTimeZone' => 'Africa/Kampala', 'currency' => 'Shilling'],
            'UA' => ['countryName' => 'Ukraine', 'iso3' => 'UKR', 'isoNumeric' => '804', 'e164' => '380', 'phoneCode' => '380', 'capitalTimeZone' => 'Europe/Kiev', 'currency' => 'Hryvnia'],
            'AE' => ['countryName' => 'United Arab Emirates', 'iso3' => 'ARE', 'isoNumeric' => '784', 'e164' => '971', 'phoneCode' => '971', 'capitalTimeZone' => 'Asia/Dubai', 'currency' => 'Dirham'],
            'GB' => ['countryName' => 'United Kingdom', 'iso3' => 'GBR', 'isoNumeric' => '826', 'e164' => '44', 'phoneCode' => '44', 'capitalTimeZone' => 'Europe/London', 'currency' => 'Pound'],
            'US' => ['countryName' => 'United States', 'iso3' => 'USA', 'isoNumeric' => '840', 'e164' => '1', 'phoneCode' => '1', 'capitalTimeZone' => 'America/New_York', 'currency' => 'Dollar'],
            'UY' => ['countryName' => 'Uruguay', 'iso3' => 'URY', 'isoNumeric' => '858', 'e164' => '598', 'phoneCode' => '598', 'capitalTimeZone' => 'America/Montevideo', 'currency' => 'Peso'],
            'UZ' => ['countryName' => 'Uzbekistan', 'iso3' => 'UZB', 'isoNumeric' => '860', 'e164' => '998', 'phoneCode' => '998', 'capitalTimeZone' => 'Asia/Tashkent', 'currency' => 'Som'],
            'VU' => ['countryName' => 'Vanuatu', 'iso3' => 'VUT', 'isoNumeric' => '548', 'e164' => '678', 'phoneCode' => '678', 'capitalTimeZone' => 'Pacific/Efate', 'currency' => 'Vatu'],
            'VA' => ['countryName' => 'Vatican', 'iso3' => 'VAT', 'isoNumeric' => '336', 'e164' => '39', 'phoneCode' => '379', 'capitalTimeZone' => 'Europe/Rome', 'currency' => 'Euro'],
            'VE' => ['countryName' => 'Venezuela', 'iso3' => 'VEN', 'isoNumeric' => '862', 'e164' => '58', 'phoneCode' => '58', 'capitalTimeZone' => 'America/Caracas', 'currency' => 'Bolivar'],
            'VN' => ['countryName' => 'Vietnam', 'iso3' => 'VNM', 'isoNumeric' => '704', 'e164' => '84', 'phoneCode' => '84', 'capitalTimeZone' => 'Asia/Ho_Chi_Minh', 'currency' => 'Dong'],
            'WF' => ['countryName' => 'Wallis and Futuna', 'iso3' => 'WLF', 'isoNumeric' => '876', 'e164' => '681', 'phoneCode' => '681', 'capitalTimeZone' => 'Pacific/Wallis', 'currency' => 'Franc'],
            'EH' => ['countryName' => 'Western Sahara', 'iso3' => 'ESH', 'isoNumeric' => '732', 'e164' => '212', 'phoneCode' => '212', 'capitalTimeZone' => 'Africa/El_Aaiun', 'currency' => 'Dirham'],
            'YE' => ['countryName' => 'Yemen', 'iso3' => 'YEM', 'isoNumeric' => '887', 'e164' => '967', 'phoneCode' => '967', 'capitalTimeZone' => 'Asia/Aden', 'currency' => 'Rial'],
            'ZM' => ['countryName' => 'Zambia', 'iso3' => 'ZMB', 'isoNumeric' => '894', 'e164' => '260', 'phoneCode' => '260', 'capitalTimeZone' => 'Africa/Maputo', 'currency' => 'Kwacha'],
            'ZW' => ['countryName' => 'Zimbabwe', 'iso3' => 'ZWE', 'isoNumeric' => '716', 'e164' => '263', 'phoneCode' => '263', 'capitalTimeZone' => 'Africa/Maputo', 'currency' => 'Dollar'],
        ];
    }
}
