<?php

namespace Syde\Vendor\Worldline\OnlinePayments\Sdk\Examples;

use Exception;
use Syde\Vendor\Worldline\OnlinePayments\Sdk\ClientTestCase;
use Syde\Vendor\Worldline\OnlinePayments\Sdk\ApiException;
use Syde\Vendor\Worldline\OnlinePayments\Sdk\Domain\AmountOfMoney;
use Syde\Vendor\Worldline\OnlinePayments\Sdk\Domain\Card;
use Syde\Vendor\Worldline\OnlinePayments\Sdk\Domain\CardPayoutMethodSpecificInput;
use Syde\Vendor\Worldline\OnlinePayments\Sdk\Domain\CreatePayoutRequest;
use Syde\Vendor\Worldline\OnlinePayments\Sdk\Domain\PaymentReferences;

/**
 * @group examples
 *
 */
class PayoutTest extends ClientTestCase
{
    /**
     * @return string
     * @throws Exception
     */
    public function testCreatePayout()
    {
        $this->markTestSkipped('Payouts are not available for all merchants');

        $client = $this->getClient();
        $merchantId = $this->getMerchantId();

        $createPayoutRequest = new CreatePayoutRequest();

        $amountOfMoney = new AmountOfMoney();
        $amountOfMoney->setAmount(2345);
        $amountOfMoney->setCurrencyCode("EUR");
        $createPayoutRequest->setAmountOfMoney($amountOfMoney);

        $cardPayoutMethodSpecificInput = new CardPayoutMethodSpecificInput();
        $cardPayoutMethodSpecificInput->setPaymentProductId(1);

        $card = new Card();
        $card->setCardholderName("Wile E. Coyote");
        $card->setCardNumber("4567350000427977");
        $card->setCvv("123");
        $card->setExpiryDate("1230");
        $cardPayoutMethodSpecificInput->setCard($card);

        $payoutReferences = new PaymentReferences();
        $payoutReferences->setMerchantReference("AcmeOrder0001");
        $createPayoutRequest->setReferences($payoutReferences);

        $payoutResponse = $client->merchant($merchantId)->payouts()->createPayout($createPayoutRequest);

        return $payoutResponse->getId();
    }

    /**
     * @depends testCreatePayout
     * @param string $payoutId
     * @return string
     * @throws ApiException|Exception
     */
    public function testRetrievePayout($payoutId)
    {
        $client = $this->getClient();
        $merchantId = $this->getMerchantId();

        $payoutResponse = $client->merchant($merchantId)->payouts()->getPayout($payoutId);
        return $payoutResponse->getId();
    }
}
