<?php

namespace Syde\Vendor\Worldline\Psr\Http\Server;

use Syde\Vendor\Worldline\Psr\Http\Message\ResponseInterface;
use Syde\Vendor\Worldline\Psr\Http\Message\ServerRequestInterface;
/**
 * Participant in processing a server request and response.
 *
 * An HTTP middleware component participates in processing an HTTP message:
 * by acting on the request, generating the response, or forwarding the
 * request to a subsequent middleware and possibly acting on its response.
 */
interface MiddlewareInterface
{
    /**
     * Process an incoming server request.
     *
     * Processes an incoming server request in order to produce a response.
     * If unable to produce the response itself, it may delegate to the provided
     * request handler to do so.
     */
    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler) : ResponseInterface;
}
