<?php

/*
 * This file was automatically generated.
 */
namespace Syde\Vendor\Worldline\OnlinePayments\Sdk\Domain;

use UnexpectedValueException;
/**
 * @package OnlinePayments\Sdk\Domain
 */
class CreateTokenRequest extends DataObject
{
    /**
     * @var TokenCardSpecificInput
     */
    public $card = null;
    /**
     * @var int
     */
    public $paymentProductId = null;
    /**
     * @return TokenCardSpecificInput
     */
    public function getCard()
    {
        return $this->card;
    }
    /**
     * @param TokenCardSpecificInput
     */
    public function setCard($value)
    {
        $this->card = $value;
    }
    /**
     * @return int
     */
    public function getPaymentProductId()
    {
        return $this->paymentProductId;
    }
    /**
     * @param int
     */
    public function setPaymentProductId($value)
    {
        $this->paymentProductId = $value;
    }
    /**
     * @return object
     */
    public function toObject()
    {
        $object = parent::toObject();
        if (!\is_null($this->card)) {
            $object->card = $this->card->toObject();
        }
        if (!\is_null($this->paymentProductId)) {
            $object->paymentProductId = $this->paymentProductId;
        }
        return $object;
    }
    /**
     * @param object $object
     * @return $this
     * @throws UnexpectedValueException
     */
    public function fromObject($object)
    {
        parent::fromObject($object);
        if (\property_exists($object, 'card')) {
            if (!\is_object($object->card)) {
                throw new UnexpectedValueException('value \'' . \print_r($object->card, \true) . '\' is not an object');
            }
            $value = new TokenCardSpecificInput();
            $this->card = $value->fromObject($object->card);
        }
        if (\property_exists($object, 'paymentProductId')) {
            $this->paymentProductId = $object->paymentProductId;
        }
        return $this;
    }
}
